<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
/**
*
* Theme: 	original
*
* @since 1.1.0
* @version 1.0.0
*
*/

class Uwac_widget_theme_original{
	public function __construct(){
		$this->theme_name   = 'original';
		$this->theme_prefix = 'uwac_theme-'.$this->theme_name;
	}
	
	public function get_settings(){
		$theme_id 		= $this->theme_prefix;
		$theme_prefix 	= $theme_id .'__';
		$styles_path 	= CS_UWAC_PLUGIN_URI .'/themes/widget/'.$this->theme_name;
		
		$settings 		= array(
			'dependency'	=> array('floatingwidget_theme_'.$this->theme_name,'==','true'),
			'id'			=> $theme_id,
			'type'			=> 'fieldset',
			'fields'		=> array(
				array(
					'type'			=> 'subheading',
					'content'		=> __('Original Theme - Settings','uwac'),
				),
				array(
					'id'			=> $theme_prefix.'colors',
					'type'			=> 'container',
					'fields'		=> array(
						array(
							'id'        => $theme_prefix.'button_colors',
							'type'      => 'color_group',
							'title'     => __('Button Colors','uwac'),
							'settings'	=> array(
								'width_style'	=> 'inline', // block - inline
							),
							'options'	=> array(
								'color-button-bg' 	=> __('Background','uwac'),
								'color-button-text' => __('Icon','uwac'),
							),
							'default'   => array(
								'color-button-bg' 	=> '#ffffff',
								'color-button-text' => '#2db742',
							),
						),
						array(
							'id'        => $theme_prefix.'popup_colors',
							'type'      => 'color_group',
							'title'     => __('Popup Window Colors','uwac'),
							'settings'	=> array(
								'width_style'	=> 'inline', // block - inline
							),
							'options'	=> array(
								array(
									'type'	=> 'group',
									'title'	=> __('Header Colors','uwac'),
									'colors'	=> array(
										'color-header-bg' 			=> __('Background','uwac'),
										'color-header-icon'			=> __('Icon','uwac'),
										'color-header-text-title' 	=> __('Title Text','uwac'),
										'color-header-text-desc' 	=> __('Description Text','uwac'),
									),
								),
							),
							'default'   => array(
								'color-header-bg' 			=> 'rgb(9, 94, 84)',
								'color-header-icon'			=> 'rgb(255,255,255)',
								'color-header-text-title' 	=> 'rgb(255,255,255)',
								'color-header-text-desc' 	=> 'rgb(255,255,255)',
							),
						),
					),
				),
				
				
				
				
				array(
					'id'            => $theme_prefix.'position',
					'type'          => 'select',
					'title'         => __('Widget Position','uwac'),
					'options'		=> array(
						'bottomleft'	=> __('Bottom Left','uwac'),
						'bottomright'	=> __('Bottom Right','uwac'),
					),
					'default'		=> 'bottomright',
					'columns' 		=> '6',
				),
				array(
					'id'			=> $theme_prefix.'widget_position',
					'type'			=> 'container',
					'label_type'	=> 'top',
					'columns' 		=> '6',
					'fields'		=> array(
						array(
							'dependency'	=> array($theme_prefix.'position','==','bottomleft'),
							'id'			=> $theme_prefix.'position_bottomleft',
							'type'			=> 'spacing',
							'settings' 		=> array(
								'all'		=> false,
								'right'		=> false,
								'top'		=> false,
								'unit'		=> false,
							),
							'default'		=> array(
								'bottom'	=> '20',
								'left'		=> '20',
								'unit'		=> 'px',
							),
						),
						array(
							'dependency'	=> array($theme_prefix.'position','==','bottomright'),
							'id'			=> $theme_prefix.'position_bottomright',
							'type'			=> 'spacing',
							'settings' 		=> array(
								'all'		=> false,
								'left'		=> false,
								'top'		=> false,
								'unit'		=> false,
							),
							'default'		=> array(
								'bottom'	=> '20',
								'right'		=> '20',
								'unit'		=> 'px',
							),
						),
					),
				),
			),
		);
		return $settings;
	}
	
	public function parse_settings($settings){
		$option = function($option) use ($settings){
			$theme_prefix = $this->theme_prefix.'__';
			return $settings[$theme_prefix.$option];
		};
		$_prefix = $this->theme_prefix.'__';
		
		
		// Parse Settings
		// ==========================================================================
		// $_c = new Colors();
		
		// Theme
		$c = $option('colors');
		$b = $c[$_prefix.'button_colors'];
		$p = $c[$_prefix.'popup_colors'];

		// Button
		$button_bg 		= $b['color-button-bg'];
		$button_text 	= $b['color-button-text'];
		
		// Popup
		$header_bg 			= $p['color-header-bg'];
		$header_icon 		= $p['color-header-icon'];
		$header_text_title 	= $p['color-header-text-title'];
		$header_text_desc 	= $p['color-header-text-desc'];
		

		// Position
		$position 		= $option('position');
		$w_position 	= $option('widget_position');
		$position_value = $w_position["{$_prefix}position_{$position}"];
		$pos_top 	= (isset($position_value['top'])) ? $position_value['top'] .'px' : 'initial';
		$pos_right 	= (isset($position_value['right'])) ? $position_value['right'] .'px' : 'initial';
		$pos_bottom = (isset($position_value['bottom'])) ? $position_value['bottom'] .'px' : 'initial';
		$pos_left 	= (isset($position_value['left'])) ? $position_value['left'] .'px' : 'initial';

		// BG
		$bg = "url(". CS_UWAC_PLUGIN_URI ."/themes/widget/original/original-bg.png)";

		
		// Output Theme CSS Vars
		// ==========================================================================
		$output = "
			%s_button-bg:					$button_bg;
			%s_button-text: 				$button_text;

			%s_header-bg:					$header_bg;
			%s_header-icon:					$header_icon;
			%s_header-text-title: 			$header_text_title;
			%s_header-text-desc: 			$header_text_desc;

			%s_position-top:				$pos_top;
			%s_position-right:				$pos_right;
			%s_position-bottom:				$pos_bottom;
			%s_position-left:				$pos_left;

			%s_bg:							$bg;
		";
		$prefix = CS_UWAC_CSS_THEME_SLUG;
		$output = str_replace('%s',$prefix,$output);
		return $output;
	}
}